#include "positions.inc"

global_settings {
	hf_gray_16 on
}

camera {
	orthographic
	
	direction	-y
	right			mountains_dim.x*x/2
	up				mountains_dim.z*z/2
	
	location <0,1000,0>
}

#macro mountain_tex()
	crackle//spotted//bozo
	poly_wave 0.9
	turbulence 0.4
	octaves 4
	scale (2/mountains_dim.x)
	scale 1250
#end

plane {
	y, 0
	
	texture {
		pigment {
			gradient z
			//poly_wave 0.1
			translate -0.5*z
			scale (mountains_dim.z/2)
			pigment_map {
				[0.0 //rgb 0]
					mountain_tex()
					colour_map {
						[0 rgb -1.0]
						[0.7 rgb -0.0]
					}
				]
				[0.2
					gradient x
					//poly_wave 0.1
					translate -0.5*x
					scale (2/mountains_dim.z)
					scale (mountains_dim.x/2)
					pigment_map {
						[0.0 //rgb 0]
							mountain_tex()
							colour_map {
								[0 rgb -0.5]
								[0.7 rgb 0]
							}
						]
						[0.22
							mountain_tex()
							colour_map {
								[0 rgb 0]
								[0.7 rgb 1]
							}
						]
					}
				]
			}
			scale <-1,1,1>
		}
		finish {
			diffuse 0
			ambient 1
		}
	}
}